/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.ArrayList;
import java.util.List;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.ExpressionState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstUtils {
    public static List<PropertyAccessor> getPropertyAccessorsToTry(Class<?> targetType, ExpressionState state) {
        ArrayList<PropertyAccessor> specificAccessors = new ArrayList<PropertyAccessor>();
        ArrayList<PropertyAccessor> generalAccessors = new ArrayList<PropertyAccessor>();
        for (PropertyAccessor resolver : state.getPropertyAccessors()) {
            Class[] targets = resolver.getSpecificTargetClasses();
            if (targets == null) {
                generalAccessors.add(resolver);
                continue;
            }
            if (targetType == null) continue;
            int pos = 0;
            Class[] classArray = targets;
            int n2 = targets.length;
            int n3 = 0;
            while (n3 < n2) {
                Class clazz = classArray[n3];
                if (clazz == targetType) {
                    specificAccessors.add(pos++, resolver);
                } else if (clazz.isAssignableFrom(targetType)) {
                    generalAccessors.add(resolver);
                }
                ++n3;
            }
        }
        ArrayList<PropertyAccessor> resolvers = new ArrayList<PropertyAccessor>();
        resolvers.addAll(specificAccessors);
        resolvers.addAll(generalAccessors);
        return resolvers;
    }
}

