/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.List;
import org.springframework.core.convert.TypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatHelper {
    public static String formatMethodForMessage(String name, List<TypeDescriptor> argumentTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append("(");
        int i2 = 0;
        while (i2 < argumentTypes.size()) {
            if (i2 > 0) {
                sb.append(",");
            }
            sb.append(FormatHelper.formatClassNameForMessage(argumentTypes.get(i2).getType()));
            ++i2;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String formatClassNameForMessage(Class<?> clazz) {
        if (clazz == null) {
            return "null";
        }
        StringBuilder fmtd = new StringBuilder();
        if (clazz.isArray()) {
            int dims = 1;
            Class<?> baseClass = clazz.getComponentType();
            while (baseClass.isArray()) {
                baseClass = baseClass.getComponentType();
                ++dims;
            }
            fmtd.append(baseClass.getName());
            int i2 = 0;
            while (i2 < dims) {
                fmtd.append("[]");
                ++i2;
            }
        } else {
            fmtd.append(clazz.getName());
        }
        return fmtd.toString();
    }
}

