/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public class QualifiedIdentifier
extends SpelNodeImpl {
    private TypedValue value;

    public QualifiedIdentifier(int pos, SpelNodeImpl ... operands) {
        super(pos, operands);
    }

    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        if (this.value == null) {
            StringBuilder sb = new StringBuilder();
            int i2 = 0;
            while (i2 < this.getChildCount()) {
                Object value = this.children[i2].getValueInternal(state).getValue();
                if (i2 > 0 && !value.toString().startsWith("$")) {
                    sb.append(".");
                }
                sb.append(value);
                ++i2;
            }
            this.value = new TypedValue(sb.toString());
        }
        return this.value;
    }

    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        if (this.value != null) {
            sb.append(this.value.getValue());
        } else {
            int i2 = 0;
            while (i2 < this.getChildCount()) {
                if (i2 > 0) {
                    sb.append(".");
                }
                sb.append(this.getChild(i2).toStringAST());
                ++i2;
            }
        }
        return sb.toString();
    }
}

