/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.jdbc.config.SortedResourcesFactoryBean;
import org.springframework.jdbc.datasource.init.DataSourceInitializer;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializeDatabaseBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    @Override
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext context) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(DataSourceInitializer.class);
        builder.addPropertyReference("dataSource", element.getAttribute("data-source"));
        builder.addPropertyValue("enabled", element.getAttribute("enabled"));
        this.setDatabasePopulator(element, context, builder);
        return this.getSourcedBeanDefinition(builder, element, context);
    }

    @Override
    protected boolean shouldGenerateId() {
        return true;
    }

    private void setDatabasePopulator(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        List<Element> scripts = DomUtils.getChildElementsByTagName(element, "script");
        if (scripts.size() > 0) {
            builder.addPropertyValue("databasePopulator", this.createDatabasePopulator(element, scripts, context));
        }
    }

    private BeanDefinition createDatabasePopulator(Element element, List<Element> scripts, ParserContext context) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ResourceDatabasePopulator.class);
        builder.addPropertyValue("ignoreFailedDrops", element.getAttribute("ignore-failures").equals("DROPS"));
        builder.addPropertyValue("continueOnError", element.getAttribute("ignore-failures").equals("ALL"));
        ArrayList<String> locations = new ArrayList<String>();
        for (Element scriptElement : scripts) {
            String location = scriptElement.getAttribute("location");
            locations.add(location);
        }
        BeanDefinitionBuilder resourcesFactory = BeanDefinitionBuilder.genericBeanDefinition(SortedResourcesFactoryBean.class);
        resourcesFactory.addConstructorArgValue(locations);
        builder.addPropertyValue("scripts", resourcesFactory.getBeanDefinition());
        return builder.getBeanDefinition();
    }

    private AbstractBeanDefinition getSourcedBeanDefinition(BeanDefinitionBuilder builder, Element source, ParserContext context) {
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        definition.setSource(context.extractSource(source));
        return definition;
    }
}

