/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.support;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLobCreatingPreparedStatementCallback
implements PreparedStatementCallback<Integer> {
    private final LobHandler lobHandler;

    public AbstractLobCreatingPreparedStatementCallback(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    @Override
    public final Integer doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
        LobCreator lobCreator = this.lobHandler.getLobCreator();
        try {
            this.setValues(ps, lobCreator);
            Integer n2 = ps.executeUpdate();
            return n2;
        }
        finally {
            lobCreator.close();
        }
    }

    protected abstract void setValues(PreparedStatement var1, LobCreator var2) throws SQLException, DataAccessException;
}

