/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.springframework.mock.web.MockServletContext;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockFilterConfig
implements FilterConfig {
    private final ServletContext servletContext;
    private final String filterName;
    private final Map<String, String> initParameters = new LinkedHashMap<String, String>();

    public MockFilterConfig() {
        this(null, "");
    }

    public MockFilterConfig(String filterName) {
        this(null, filterName);
    }

    public MockFilterConfig(ServletContext servletContext) {
        this(servletContext, "");
    }

    public MockFilterConfig(ServletContext servletContext, String filterName) {
        this.servletContext = servletContext != null ? servletContext : new MockServletContext();
        this.filterName = filterName;
    }

    @Override
    public String getFilterName() {
        return this.filterName;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void addInitParameter(String name, String value) {
        Assert.notNull(name, "Parameter name must not be null");
        this.initParameters.put(name, value);
    }

    @Override
    public String getInitParameter(String name) {
        Assert.notNull(name, "Parameter name must not be null");
        return this.initParameters.get(name);
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration((Collection)this.initParameters.keySet());
    }
}

