/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import java.sql.Connection;
import javax.sql.DataSource;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.JDBCException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.classic.Session;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.impl.SessionImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
BeanFactoryAware,
InitializingBean {
    private SessionFactory sessionFactory;
    private DataSource dataSource;
    private boolean autodetectDataSource = true;
    private boolean prepareConnection = true;
    private boolean hibernateManagedSession = false;
    private boolean earlyFlushBeforeCommit = false;
    private Object entityInterceptor;
    private SQLExceptionTranslator jdbcExceptionTranslator;
    private SQLExceptionTranslator defaultJdbcExceptionTranslator;
    private BeanFactory beanFactory;

    public HibernateTransactionManager() {
    }

    public HibernateTransactionManager(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.afterPropertiesSet();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setAutodetectDataSource(boolean autodetectDataSource) {
        this.autodetectDataSource = autodetectDataSource;
    }

    public void setPrepareConnection(boolean prepareConnection) {
        this.prepareConnection = prepareConnection;
    }

    public void setHibernateManagedSession(boolean hibernateManagedSession) {
        this.hibernateManagedSession = hibernateManagedSession;
    }

    public void setEarlyFlushBeforeCommit(boolean earlyFlushBeforeCommit) {
        this.earlyFlushBeforeCommit = earlyFlushBeforeCommit;
    }

    public void setEntityInterceptorBeanName(String entityInterceptorBeanName) {
        this.entityInterceptor = entityInterceptorBeanName;
    }

    public void setEntityInterceptor(Interceptor entityInterceptor) {
        this.entityInterceptor = entityInterceptor;
    }

    public Interceptor getEntityInterceptor() throws IllegalStateException, BeansException {
        if (this.entityInterceptor instanceof Interceptor) {
            return (Interceptor)this.entityInterceptor;
        }
        if (this.entityInterceptor instanceof String) {
            if (this.beanFactory == null) {
                throw new IllegalStateException("Cannot get entity interceptor via bean name if no bean factory set");
            }
            String beanName = (String)this.entityInterceptor;
            return this.beanFactory.getBean(beanName, Interceptor.class);
        }
        return null;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        return this.jdbcExceptionTranslator;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        DataSource sfds;
        if (this.getSessionFactory() == null) {
            throw new IllegalArgumentException("Property 'sessionFactory' is required");
        }
        if (this.entityInterceptor instanceof String && this.beanFactory == null) {
            throw new IllegalArgumentException("Property 'beanFactory' is required for 'entityInterceptorBeanName'");
        }
        if (this.autodetectDataSource && this.getDataSource() == null && (sfds = SessionFactoryUtils.getDataSource(this.getSessionFactory())) != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Using DataSource [" + sfds + "] of Hibernate SessionFactory for HibernateTransactionManager");
            }
            this.setDataSource(sfds);
        }
    }

    public Object getResourceFactory() {
        return this.getSessionFactory();
    }

    protected Object doGetTransaction() {
        HibernateTransactionObject txObject = new HibernateTransactionObject();
        txObject.setSavepointAllowed(this.isNestedTransactionAllowed());
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(this.getSessionFactory());
        if (sessionHolder != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found thread-bound Session [" + SessionFactoryUtils.toString(sessionHolder.getSession()) + "] for Hibernate transaction");
            }
            txObject.setSessionHolder(sessionHolder);
        } else if (this.hibernateManagedSession) {
            try {
                Session session = this.getSessionFactory().getCurrentSession();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Found Hibernate-managed Session [" + SessionFactoryUtils.toString((org.hibernate.Session)session) + "] for Spring-managed transaction");
                }
                txObject.setExistingSession((org.hibernate.Session)session);
            }
            catch (HibernateException ex) {
                throw new DataAccessResourceFailureException("Could not obtain Hibernate-managed Session for Spring-managed transaction", ex);
            }
        }
        if (this.getDataSource() != null) {
            ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource(this.getDataSource());
            txObject.setConnectionHolder(conHolder);
        }
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)transaction;
        return txObject.hasSpringManagedTransaction() || this.hibernateManagedSession && txObject.hasHibernateManagedTransaction();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)transaction;
        if (txObject.hasConnectionHolder() && !txObject.getConnectionHolder().isSynchronizedWithTransaction()) {
            throw new IllegalTransactionStateException("Pre-bound JDBC Connection found! HibernateTransactionManager does not support running within DataSourceTransactionManager if told to manage the DataSource itself. It is recommended to use a single HibernateTransactionManager for all transactions on a single DataSource, no matter whether Hibernate or JDBC access.");
        }
        org.hibernate.Session session = null;
        try {
            Transaction hibTx;
            int timeout;
            FlushMode flushMode;
            if (txObject.getSessionHolder() == null || txObject.getSessionHolder().isSynchronizedWithTransaction()) {
                Session newSession;
                Interceptor entityInterceptor = this.getEntityInterceptor();
                Session session2 = newSession = entityInterceptor != null ? this.getSessionFactory().openSession(entityInterceptor) : this.getSessionFactory().openSession();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Opened new Session [" + SessionFactoryUtils.toString((org.hibernate.Session)newSession) + "] for Hibernate transaction");
                }
                txObject.setSession((org.hibernate.Session)newSession);
            }
            session = txObject.getSessionHolder().getSession();
            if (this.prepareConnection && this.isSameConnectionForEntireSession(session)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Preparing JDBC Connection of Hibernate Session [" + SessionFactoryUtils.toString(session) + "]");
                }
                Connection con = session.connection();
                Integer previousIsolationLevel = DataSourceUtils.prepareConnectionForTransaction(con, definition);
                txObject.setPreviousIsolationLevel(previousIsolationLevel);
            } else {
                if (definition.getIsolationLevel() != -1) {
                    throw new InvalidIsolationLevelException("HibernateTransactionManager is not allowed to support custom isolation levels: make sure that its 'prepareConnection' flag is on (the default) and that the Hibernate connection release mode is set to 'on_close' (SpringTransactionFactory's default). Make sure that your LocalSessionFactoryBean actually uses SpringTransactionFactory: Your Hibernate properties should *not* include a 'hibernate.transaction.factory_class' property!");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Not preparing JDBC Connection of Hibernate Session [" + SessionFactoryUtils.toString(session) + "]");
                }
            }
            if (definition.isReadOnly() && txObject.isNewSession()) {
                session.setFlushMode(FlushMode.MANUAL);
            }
            if (!definition.isReadOnly() && !txObject.isNewSession() && (flushMode = session.getFlushMode()).lessThan(FlushMode.COMMIT)) {
                session.setFlushMode(FlushMode.AUTO);
                txObject.getSessionHolder().setPreviousFlushMode(flushMode);
            }
            if ((timeout = this.determineTimeout(definition)) != -1) {
                hibTx = session.getTransaction();
                hibTx.setTimeout(timeout);
                hibTx.begin();
            } else {
                hibTx = session.beginTransaction();
            }
            txObject.getSessionHolder().setTransaction(hibTx);
            if (this.getDataSource() != null) {
                Connection con = session.connection();
                ConnectionHolder conHolder = new ConnectionHolder(con);
                if (timeout != -1) {
                    conHolder.setTimeoutInSeconds(timeout);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Exposing Hibernate transaction as JDBC transaction [" + con + "]");
                }
                TransactionSynchronizationManager.bindResource(this.getDataSource(), conHolder);
                txObject.setConnectionHolder(conHolder);
            }
            if (txObject.isNewSessionHolder()) {
                TransactionSynchronizationManager.bindResource(this.getSessionFactory(), txObject.getSessionHolder());
            }
            txObject.getSessionHolder().setSynchronizedWithTransaction(true);
        }
        catch (Exception ex) {
            block25: {
                if (txObject.isNewSession()) {
                    try {
                        try {
                            if (session.getTransaction().isActive()) {
                                session.getTransaction().rollback();
                            }
                        }
                        catch (Throwable throwable) {
                            this.logger.debug("Could not rollback Session after failed transaction begin", ex);
                            SessionFactoryUtils.closeSession(session);
                            break block25;
                        }
                    }
                    catch (Throwable throwable) {
                        SessionFactoryUtils.closeSession(session);
                        throw throwable;
                    }
                    SessionFactoryUtils.closeSession(session);
                }
            }
            throw new CannotCreateTransactionException("Could not open Hibernate Session for transaction", ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)transaction;
        txObject.setSessionHolder(null);
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
        txObject.setConnectionHolder(null);
        ConnectionHolder connectionHolder = null;
        if (this.getDataSource() != null) {
            connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.unbindResource(this.getDataSource());
        }
        return new SuspendedResourcesHolder(sessionHolder, connectionHolder);
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        if (TransactionSynchronizationManager.hasResource(this.getSessionFactory())) {
            TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
        }
        TransactionSynchronizationManager.bindResource(this.getSessionFactory(), resourcesHolder.getSessionHolder());
        if (this.getDataSource() != null) {
            TransactionSynchronizationManager.bindResource(this.getDataSource(), resourcesHolder.getConnectionHolder());
        }
    }

    protected void prepareForCommit(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject;
        org.hibernate.Session session;
        if (this.earlyFlushBeforeCommit && status.isNewTransaction() && !(session = (txObject = (HibernateTransactionObject)status.getTransaction()).getSessionHolder().getSession()).getFlushMode().lessThan(FlushMode.COMMIT)) {
            this.logger.debug("Performing an early flush for Hibernate transaction");
            try {
                try {
                    session.flush();
                }
                catch (HibernateException ex) {
                    throw this.convertHibernateAccessException(ex);
                }
            }
            finally {
                session.setFlushMode(FlushMode.MANUAL);
            }
        }
    }

    protected void doCommit(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug("Committing Hibernate transaction on Session [" + SessionFactoryUtils.toString(txObject.getSessionHolder().getSession()) + "]");
        }
        try {
            txObject.getSessionHolder().getTransaction().commit();
        }
        catch (TransactionException ex) {
            throw new TransactionSystemException("Could not commit Hibernate transaction", ex);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug("Rolling back Hibernate transaction on Session [" + SessionFactoryUtils.toString(txObject.getSessionHolder().getSession()) + "]");
        }
        try {
            try {
                txObject.getSessionHolder().getTransaction().rollback();
            }
            catch (TransactionException ex) {
                throw new TransactionSystemException("Could not roll back Hibernate transaction", ex);
            }
            catch (HibernateException ex) {
                throw this.convertHibernateAccessException(ex);
            }
        }
        finally {
            if (!txObject.isNewSession() && !this.hibernateManagedSession) {
                txObject.getSessionHolder().getSession().clear();
            }
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug("Setting Hibernate transaction on Session [" + SessionFactoryUtils.toString(txObject.getSessionHolder().getSession()) + "] rollback-only");
        }
        txObject.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)transaction;
        if (txObject.isNewSessionHolder()) {
            TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
        }
        if (this.getDataSource() != null) {
            TransactionSynchronizationManager.unbindResource(this.getDataSource());
        }
        org.hibernate.Session session = txObject.getSessionHolder().getSession();
        if (this.prepareConnection && session.isConnected() && this.isSameConnectionForEntireSession(session)) {
            try {
                Connection con = session.connection();
                DataSourceUtils.resetConnectionAfterTransaction(con, txObject.getPreviousIsolationLevel());
            }
            catch (HibernateException ex) {
                this.logger.debug("Could not access JDBC Connection of Hibernate Session", ex);
            }
        }
        if (txObject.isNewSession()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Closing Hibernate Session [" + SessionFactoryUtils.toString(session) + "] after transaction");
            }
            SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.getSessionFactory());
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Not closing pre-bound Hibernate Session [" + SessionFactoryUtils.toString(session) + "] after transaction");
            }
            if (txObject.getSessionHolder().getPreviousFlushMode() != null) {
                session.setFlushMode(txObject.getSessionHolder().getPreviousFlushMode());
            }
            if (!this.hibernateManagedSession) {
                session.disconnect();
            }
        }
        txObject.getSessionHolder().clear();
    }

    protected boolean isSameConnectionForEntireSession(org.hibernate.Session session) {
        if (!(session instanceof SessionImpl)) {
            return true;
        }
        ConnectionReleaseMode releaseMode = ((SessionImpl)session).getConnectionReleaseMode();
        return ConnectionReleaseMode.ON_CLOSE.equals(releaseMode);
    }

    protected DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (this.getJdbcExceptionTranslator() != null && ex instanceof JDBCException) {
            return this.convertJdbcAccessException((JDBCException)ex, this.getJdbcExceptionTranslator());
        }
        if (GenericJDBCException.class.equals(((Object)((Object)ex)).getClass())) {
            return this.convertJdbcAccessException((JDBCException)((GenericJDBCException)ex), this.getDefaultJdbcExceptionTranslator());
        }
        return SessionFactoryUtils.convertHibernateAccessException(ex);
    }

    protected DataAccessException convertJdbcAccessException(JDBCException ex, SQLExceptionTranslator translator) {
        return translator.translate("Hibernate flushing: " + ex.getMessage(), ex.getSQL(), ex.getSQLException());
    }

    protected synchronized SQLExceptionTranslator getDefaultJdbcExceptionTranslator() {
        if (this.defaultJdbcExceptionTranslator == null) {
            this.defaultJdbcExceptionTranslator = this.getDataSource() != null ? new SQLErrorCodeSQLExceptionTranslator(this.getDataSource()) : SessionFactoryUtils.newJdbcExceptionTranslator(this.getSessionFactory());
        }
        return this.defaultJdbcExceptionTranslator;
    }

    private class HibernateTransactionObject
    extends JdbcTransactionObjectSupport {
        private SessionHolder sessionHolder;
        private boolean newSessionHolder;
        private boolean newSession;

        private HibernateTransactionObject() {
        }

        public void setSession(org.hibernate.Session session) {
            this.sessionHolder = new SessionHolder(session);
            this.newSessionHolder = true;
            this.newSession = true;
        }

        public void setExistingSession(org.hibernate.Session session) {
            this.sessionHolder = new SessionHolder(session);
            this.newSessionHolder = true;
            this.newSession = false;
        }

        public void setSessionHolder(SessionHolder sessionHolder) {
            this.sessionHolder = sessionHolder;
            this.newSessionHolder = false;
            this.newSession = false;
        }

        public SessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        public boolean isNewSessionHolder() {
            return this.newSessionHolder;
        }

        public boolean isNewSession() {
            return this.newSession;
        }

        public boolean hasSpringManagedTransaction() {
            return this.sessionHolder != null && this.sessionHolder.getTransaction() != null;
        }

        public boolean hasHibernateManagedTransaction() {
            return this.sessionHolder != null && this.sessionHolder.getSession().getTransaction().isActive();
        }

        public void setRollbackOnly() {
            this.sessionHolder.setRollbackOnly();
            if (this.hasConnectionHolder()) {
                this.getConnectionHolder().setRollbackOnly();
            }
        }

        public boolean isRollbackOnly() {
            return this.sessionHolder.isRollbackOnly() || this.hasConnectionHolder() && this.getConnectionHolder().isRollbackOnly();
        }

        public void flush() {
            try {
                this.sessionHolder.getSession().flush();
            }
            catch (HibernateException ex) {
                throw HibernateTransactionManager.this.convertHibernateAccessException(ex);
            }
        }
    }

    private static class SuspendedResourcesHolder {
        private final SessionHolder sessionHolder;
        private final ConnectionHolder connectionHolder;

        private SuspendedResourcesHolder(SessionHolder sessionHolder, ConnectionHolder conHolder) {
            this.sessionHolder = sessionHolder;
            this.connectionHolder = conHolder;
        }

        private SessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        private ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }
    }
}

