/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.expression.method;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.core.Authentication;

class MethodSecurityEvaluationContext
extends StandardEvaluationContext {
    private static Log logger = LogFactory.getLog(MethodSecurityEvaluationContext.class);
    private ParameterNameDiscoverer parameterNameDiscoverer;
    private boolean argumentsAdded;
    private MethodInvocation mi;

    public MethodSecurityEvaluationContext(Authentication user, MethodInvocation mi) {
        this(user, mi, new LocalVariableTableParameterNameDiscoverer());
    }

    public MethodSecurityEvaluationContext(Authentication user, MethodInvocation mi, ParameterNameDiscoverer parameterNameDiscoverer) {
        this.mi = mi;
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public Object lookupVariable(String name) {
        Object variable = super.lookupVariable(name);
        if (variable != null) {
            return variable;
        }
        if (!this.argumentsAdded) {
            this.addArgumentsAsVariables();
            this.argumentsAdded = true;
        }
        return super.lookupVariable(name);
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    private void addArgumentsAsVariables() {
        Object[] args = this.mi.getArguments();
        if (args.length == 0) {
            return;
        }
        Object targetObject = this.mi.getThis();
        Method method = AopUtils.getMostSpecificMethod(this.mi.getMethod(), targetObject.getClass());
        String[] paramNames = this.parameterNameDiscoverer.getParameterNames(method);
        if (paramNames == null) {
            logger.warn("Unable to resolve method parameter names for method: " + method + ". Debug symbol information is required if you are using parameter names in expressions.");
            return;
        }
        for (int i2 = 0; i2 < args.length; ++i2) {
            super.setVariable(paramNames[i2], args[i2]);
        }
    }
}

