/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.vote;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.vote.AbstractAclVoter;
import org.springframework.security.access.vote.LabeledData;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelBasedAclVoter
extends AbstractAclVoter {
    private static final Log logger = LogFactory.getLog(LabelBasedAclVoter.class);
    private Map<String, List<String>> labelMap = null;
    private String attributeIndicatingLabeledOperation = null;
    private boolean allowAccessIfNoAttributesAreLabeled = true;

    public void setAllowAccessIfNoAttributesAreLabeled(boolean allowAccessIfNoAttributesAreLabeled) {
        this.allowAccessIfNoAttributesAreLabeled = allowAccessIfNoAttributesAreLabeled;
    }

    public void setAttributeIndicatingLabeledOperation(String attributeIndicatingLabeledOperation) {
        this.attributeIndicatingLabeledOperation = attributeIndicatingLabeledOperation;
    }

    public void setLabelMap(Map<String, List<String>> labelMap) {
        this.labelMap = labelMap;
    }

    @Override
    public boolean supports(ConfigAttribute attribute) {
        if (attribute.getAttribute().equals(this.attributeIndicatingLabeledOperation)) {
            logger.debug(attribute + " is supported.");
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(attribute + " is unsupported.");
        }
        return false;
    }

    @Override
    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
        int result = 0;
        if (logger.isDebugEnabled()) {
            logger.debug("==========================================================");
        }
        if (this.supports(attributes.iterator().next())) {
            result = -1;
            ArrayList<String> userLabels = new ArrayList<String>();
            for (GrantedAuthority authority : authentication.getAuthorities()) {
                String userLabel = authority.getAuthority();
                if (!this.labelMap.containsKey(userLabel)) continue;
                userLabels.add(userLabel);
                logger.debug("Adding " + userLabel + " to <<<" + authentication.getName() + "'s>>> authorized label list");
            }
            MethodInvocation invocation = (MethodInvocation)object;
            int matches = 0;
            int misses = 0;
            int labeledArguments = 0;
            for (int j2 = 0; j2 < invocation.getArguments().length; ++j2) {
                if (!(invocation.getArguments()[j2] instanceof LabeledData)) continue;
                ++labeledArguments;
                boolean matched = false;
                String argumentDataLabel = ((LabeledData)invocation.getArguments()[j2]).getLabel();
                logger.debug("Argument[" + j2 + "/" + invocation.getArguments()[j2].getClass().getName() + "] has a data label of " + argumentDataLabel);
                ArrayList validDataLabels = new ArrayList();
                for (int i2 = 0; i2 < userLabels.size(); ++i2) {
                    validDataLabels.addAll(this.labelMap.get(userLabels.get(i2)));
                }
                logger.debug("The valid labels for user label " + userLabels + " are " + validDataLabels);
                for (String validDataLabel : validDataLabels) {
                    if (!argumentDataLabel.equals(validDataLabel)) continue;
                    logger.debug(userLabels + " maps to " + validDataLabel + " which matches the argument");
                    matched = true;
                }
                if (matched) {
                    logger.debug("We have a match!");
                    ++matches;
                    continue;
                }
                logger.debug("We have a miss!");
                ++misses;
            }
            Assert.isTrue(matches + misses == labeledArguments, "The matches (" + matches + ") and misses (" + misses + " ) don't add up (" + labeledArguments + ")");
            logger.debug("We have " + matches + " matches and " + misses + " misses and " + labeledArguments + " labeled arguments.");
            if (matches > 0 && misses == 0) {
                result = 1;
            } else if (labeledArguments == 0) {
                result = this.allowAccessIfNoAttributesAreLabeled ? 1 : -1;
            }
        }
        if (logger.isDebugEnabled()) {
            switch (result) {
                case 1: {
                    logger.debug("===== Access is granted =====");
                    break;
                }
                case -1: {
                    logger.debug("===== Access is denied =====");
                    break;
                }
                case 0: {
                    logger.debug("===== Abstaining =====");
                }
            }
        }
        return result;
    }
}

