/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.test.context.ContextLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContextLoader
implements ContextLoader {
    @Override
    public final String[] processLocations(Class<?> clazz, String ... locations) {
        return ObjectUtils.isEmpty(locations) && this.isGenerateDefaultLocations() ? this.generateDefaultLocations(clazz) : this.modifyLocations(clazz, locations);
    }

    protected String[] generateDefaultLocations(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        String suffix = this.getResourceSuffix();
        Assert.hasText(suffix, "Resource suffix must not be empty");
        return new String[]{"classpath:/" + ClassUtils.convertClassNameToResourcePath(clazz.getName()) + suffix};
    }

    protected String[] modifyLocations(Class<?> clazz, String ... locations) {
        String[] modifiedLocations = new String[locations.length];
        int i2 = 0;
        while (i2 < locations.length) {
            String path = locations[i2];
            modifiedLocations[i2] = path.startsWith("/") ? "classpath:" + path : (!ResourcePatternUtils.isUrl(path) ? "classpath:/" + StringUtils.cleanPath(String.valueOf(ClassUtils.classPackageAsResourcePath(clazz)) + "/" + path) : StringUtils.cleanPath(path));
            ++i2;
        }
        return modifiedLocations;
    }

    protected boolean isGenerateDefaultLocations() {
        return true;
    }

    protected abstract String getResourceSuffix();
}

