/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.jdbc;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.List;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcTestUtils {
    public static String readScript(LineNumberReader lineNumberReader) throws IOException {
        String currentStatement = lineNumberReader.readLine();
        StringBuilder scriptBuilder = new StringBuilder();
        while (currentStatement != null) {
            if (StringUtils.hasText(currentStatement)) {
                if (scriptBuilder.length() > 0) {
                    scriptBuilder.append('\n');
                }
                scriptBuilder.append(currentStatement);
            }
            currentStatement = lineNumberReader.readLine();
        }
        return scriptBuilder.toString();
    }

    public static boolean containsSqlScriptDelimiters(String script, char delim) {
        boolean inLiteral = false;
        char[] content = script.toCharArray();
        int i2 = 0;
        while (i2 < script.length()) {
            if (content[i2] == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (content[i2] == delim && !inLiteral) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public static void splitSqlScript(String script, char delim, List<String> statements) {
        StringBuilder sb = new StringBuilder();
        boolean inLiteral = false;
        char[] content = script.toCharArray();
        int i2 = 0;
        while (i2 < script.length()) {
            if (content[i2] == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (content[i2] == delim && !inLiteral) {
                if (sb.length() > 0) {
                    statements.add(sb.toString());
                    sb = new StringBuilder();
                }
            } else {
                sb.append(content[i2]);
            }
            ++i2;
        }
        if (sb.length() > 0) {
            statements.add(sb.toString());
        }
    }
}

