/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.AbstractStaxXMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.AttributesImpl;

class StaxStreamXMLReader
extends AbstractStaxXMLReader {
    private static final String DEFAULT_XML_VERSION = "1.0";
    private final XMLStreamReader reader;
    private String xmlVersion = "1.0";
    private String encoding;

    StaxStreamXMLReader(XMLStreamReader reader) {
        Assert.notNull(reader, "'reader' must not be null");
        int event = reader.getEventType();
        if (event != 7 && event != 1) {
            throw new IllegalStateException("XMLEventReader not at start of document or element");
        }
        this.reader = reader;
    }

    protected void parseInternal() throws SAXException, XMLStreamException {
        boolean documentStarted = false;
        boolean documentEnded = false;
        int elementDepth = 0;
        int eventType = this.reader.getEventType();
        while (true) {
            if (eventType != 7 && eventType != 8 && !documentStarted) {
                this.handleStartDocument();
                documentStarted = true;
            }
            switch (eventType) {
                case 1: {
                    ++elementDepth;
                    this.handleStartElement();
                    break;
                }
                case 2: {
                    if (--elementDepth < 0) break;
                    this.handleEndElement();
                    break;
                }
                case 3: {
                    this.handleProcessingInstruction();
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    this.handleCharacters();
                    break;
                }
                case 7: {
                    this.handleStartDocument();
                    documentStarted = true;
                    break;
                }
                case 8: {
                    this.handleEndDocument();
                    documentEnded = true;
                    break;
                }
                case 5: {
                    this.handleComment();
                    break;
                }
                case 11: {
                    this.handleDtd();
                    break;
                }
                case 9: {
                    this.handleEntityReference();
                }
            }
            if (!this.reader.hasNext() || elementDepth < 0) break;
            eventType = this.reader.next();
        }
        if (!documentEnded) {
            this.handleEndDocument();
        }
    }

    private void handleStartDocument() throws SAXException {
        if (7 == this.reader.getEventType()) {
            String xmlVersion = this.reader.getVersion();
            if (StringUtils.hasLength(xmlVersion)) {
                this.xmlVersion = xmlVersion;
            }
            this.encoding = this.reader.getCharacterEncodingScheme();
        }
        if (this.getContentHandler() != null) {
            final Location location = this.reader.getLocation();
            this.getContentHandler().setDocumentLocator(new Locator2(){

                public int getColumnNumber() {
                    return location != null ? location.getColumnNumber() : -1;
                }

                public int getLineNumber() {
                    return location != null ? location.getLineNumber() : -1;
                }

                public String getPublicId() {
                    return location != null ? location.getPublicId() : null;
                }

                public String getSystemId() {
                    return location != null ? location.getSystemId() : null;
                }

                public String getXMLVersion() {
                    return StaxStreamXMLReader.this.xmlVersion;
                }

                public String getEncoding() {
                    return StaxStreamXMLReader.this.encoding;
                }
            });
            this.getContentHandler().startDocument();
            if (this.reader.standaloneSet()) {
                this.setStandalone(this.reader.isStandalone());
            }
        }
    }

    private void handleStartElement() throws SAXException {
        if (this.getContentHandler() != null) {
            QName qName = this.reader.getName();
            if (this.hasNamespacesFeature()) {
                int i2 = 0;
                while (i2 < this.reader.getNamespaceCount()) {
                    this.startPrefixMapping(this.reader.getNamespacePrefix(i2), this.reader.getNamespaceURI(i2));
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.reader.getAttributeCount()) {
                    String prefix = this.reader.getAttributePrefix(i2);
                    String namespace = this.reader.getAttributeNamespace(i2);
                    if (StringUtils.hasLength(namespace)) {
                        this.startPrefixMapping(prefix, namespace);
                    }
                    ++i2;
                }
                this.getContentHandler().startElement(qName.getNamespaceURI(), qName.getLocalPart(), this.toQualifiedName(qName), this.getAttributes());
            } else {
                this.getContentHandler().startElement("", "", this.toQualifiedName(qName), this.getAttributes());
            }
        }
    }

    private void handleEndElement() throws SAXException {
        if (this.getContentHandler() != null) {
            QName qName = this.reader.getName();
            if (this.hasNamespacesFeature()) {
                this.getContentHandler().endElement(qName.getNamespaceURI(), qName.getLocalPart(), this.toQualifiedName(qName));
                int i2 = 0;
                while (i2 < this.reader.getNamespaceCount()) {
                    String prefix = this.reader.getNamespacePrefix(i2);
                    if (prefix == null) {
                        prefix = "";
                    }
                    this.endPrefixMapping(prefix);
                    ++i2;
                }
            } else {
                this.getContentHandler().endElement("", "", this.toQualifiedName(qName));
            }
        }
    }

    private void handleCharacters() throws SAXException {
        if (this.getContentHandler() != null && this.reader.isWhiteSpace()) {
            this.getContentHandler().ignorableWhitespace(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
            return;
        }
        if (12 == this.reader.getEventType() && this.getLexicalHandler() != null) {
            this.getLexicalHandler().startCDATA();
        }
        if (this.getContentHandler() != null) {
            this.getContentHandler().characters(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
        }
        if (12 == this.reader.getEventType() && this.getLexicalHandler() != null) {
            this.getLexicalHandler().endCDATA();
        }
    }

    private void handleComment() throws SAXException {
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().comment(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
        }
    }

    private void handleDtd() throws SAXException {
        if (this.getLexicalHandler() != null) {
            Location location = this.reader.getLocation();
            this.getLexicalHandler().startDTD(null, location.getPublicId(), location.getSystemId());
        }
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().endDTD();
        }
    }

    private void handleEntityReference() throws SAXException {
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().startEntity(this.reader.getLocalName());
        }
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().endEntity(this.reader.getLocalName());
        }
    }

    private void handleEndDocument() throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().endDocument();
        }
    }

    private void handleProcessingInstruction() throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().processingInstruction(this.reader.getPITarget(), this.reader.getPIData());
        }
    }

    private Attributes getAttributes() {
        AttributesImpl attributes = new AttributesImpl();
        int i2 = 0;
        while (i2 < this.reader.getAttributeCount()) {
            String type;
            String namespace = this.reader.getAttributeNamespace(i2);
            if (namespace == null || !this.hasNamespacesFeature()) {
                namespace = "";
            }
            if ((type = this.reader.getAttributeType(i2)) == null) {
                type = "CDATA";
            }
            attributes.addAttribute(namespace, this.reader.getAttributeLocalName(i2), this.toQualifiedName(this.reader.getAttributeName(i2)), type, this.reader.getAttributeValue(i2));
            ++i2;
        }
        if (this.hasNamespacePrefixesFeature()) {
            i2 = 0;
            while (i2 < this.reader.getNamespaceCount()) {
                String prefix = this.reader.getNamespacePrefix(i2);
                String namespaceUri = this.reader.getNamespaceURI(i2);
                String qName = StringUtils.hasLength(prefix) ? "xmlns:" + prefix : "xmlns";
                attributes.addAttribute("", "", qName, "CDATA", namespaceUri);
                ++i2;
            }
        }
        return attributes;
    }
}

