/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import java.beans.PropertyEditor;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.springframework.web.servlet.tags.EditorAwareTag;
import org.springframework.web.servlet.tags.HtmlEscapingAwareTag;
import org.springframework.web.util.ExpressionEvaluationUtils;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.TagUtils;

public class TransformTag
extends HtmlEscapingAwareTag {
    private Object value;
    private String var;
    private String scope = "page";

    public void setValue(Object value) {
        this.value = value;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    protected final int doStartTagInternal() throws JspException {
        Object resolvedValue = this.value;
        if (this.value instanceof String) {
            String strValue = (String)this.value;
            resolvedValue = ExpressionEvaluationUtils.evaluate("value", strValue, this.pageContext);
        }
        if (resolvedValue != null) {
            EditorAwareTag tag = (EditorAwareTag)((Object)TagSupport.findAncestorWithClass(this, EditorAwareTag.class));
            if (tag == null) {
                throw new JspException("TransformTag can only be used within EditorAwareTag (e.g. BindTag)");
            }
            String result = null;
            PropertyEditor editor = tag.getEditor();
            if (editor != null) {
                editor.setValue(resolvedValue);
                result = editor.getAsText();
            } else {
                result = resolvedValue.toString();
            }
            result = this.isHtmlEscape() ? HtmlUtils.htmlEscape(result) : result;
            String resolvedVar = ExpressionEvaluationUtils.evaluateString("var", this.var, this.pageContext);
            if (resolvedVar != null) {
                String resolvedScope = ExpressionEvaluationUtils.evaluateString("scope", this.scope, this.pageContext);
                this.pageContext.setAttribute(resolvedVar, result, TagUtils.getScope(resolvedScope));
            } else {
                try {
                    this.pageContext.getOut().print(result);
                }
                catch (IOException ex) {
                    throw new JspException(ex);
                }
            }
        }
        return 0;
    }
}

