/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.tiles2;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.tiles.Initializable;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.context.AbstractTilesApplicationContextFactory;
import org.apache.tiles.servlet.context.ServletTilesApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringTilesApplicationContextFactory
extends AbstractTilesApplicationContextFactory
implements Initializable {
    private Map<String, String> params;

    public void init(Map<String, String> params) {
        this.params = params;
    }

    public TilesApplicationContext createApplicationContext(Object context) {
        return new SpringWildcardServletTilesApplicationContext((ServletContext)context, this.params);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SpringWildcardServletTilesApplicationContext
    extends ServletTilesApplicationContext {
        private final Map<String, String> mergedInitParams = new LinkedHashMap<String, String>();
        private final ResourcePatternResolver resolver;

        public SpringWildcardServletTilesApplicationContext(ServletContext servletContext, Map<String, String> params) {
            super(servletContext);
            Enumeration<String> initParamNames = servletContext.getInitParameterNames();
            while (initParamNames.hasMoreElements()) {
                String initParamName = initParamNames.nextElement();
                this.mergedInitParams.put(initParamName, servletContext.getInitParameter(initParamName));
            }
            if (params != null) {
                this.mergedInitParams.putAll(params);
            }
            this.resolver = new ServletContextResourcePatternResolver(servletContext);
        }

        public Map<String, String> getInitParams() {
            return this.mergedInitParams;
        }

        public URL getResource(String path) throws IOException {
            URL retValue = null;
            Set<URL> urlSet = this.getResources(path);
            if (urlSet != null && !urlSet.isEmpty()) {
                retValue = urlSet.iterator().next();
            }
            return retValue;
        }

        public Set<URL> getResources(String path) throws IOException {
            HashSet<URL> urlSet = null;
            Resource[] resources = this.resolver.getResources(path);
            if (resources != null && resources.length > 0) {
                urlSet = new HashSet<URL>();
                Resource[] resourceArray = resources;
                int n2 = resources.length;
                int n3 = 0;
                while (n3 < n2) {
                    Resource resource = resourceArray[n3];
                    urlSet.add(resource.getURL());
                    ++n3;
                }
            }
            return urlSet;
        }
    }
}

